//---------------------------------------------------------------------
#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "TCPPrintMain.h"
#include "TCPPrintAboutUnit.h"

//---------------------------------------------------------------------
#pragma resource "*.dfm"
TTCPPrintForm *TCPPrintForm;
//---------------------------------------------------------------------
__fastcall TTCPPrintForm::TTCPPrintForm(TComponent *AOwner)
	: TForm(AOwner)
{
}
//---------------------------------------------------------------------

void __fastcall TTCPPrintForm::FileNew1Execute(TObject *Sender)
{
  // Do nothing        
}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::WebPrintServerClientConnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
TMemoryStream* PrnStream=new  TMemoryStream;
Socket->Data=PrnStream;

}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::WebPrintServerClientRead(TObject *Sender,
      TCustomWinSocket *Socket)
{
int ResLn=Socket->ReceiveLength();
char * Rb=new char[ResLn];
Socket->ReceiveBuf(Rb,ResLn);

if (((TMemoryStream*)Socket->Data)->Size==0 && ResLn>3)
{
 if (Rb[0]=='G' && Rb[1]=='E' && Rb[2]=='T' )
        {
                String PrinterName="";
                int srv_port=0;
                TServerSocket * srv_SS=NULL;

                 for(int c=0; c<ServiceList->Count; c++)
                {
                 srv_SS=((Srv*)ServiceList->Items[c])->SS;

                for(int a=0; a<srv_SS->Socket->ActiveConnections;a++)
                        {
                        if(srv_SS->Socket->Connections[a]==Socket)
                                {
                                srv_port=srv_SS->Port;
                                PrinterName=((Srv*)ServiceList->Items[c])->PN;
                                break;
                                }
                        }
                 }
                 String SendMsg= "<Html><header><meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\"></header>" ;
                        SendMsg=SendMsg+ DateTimeToStr(Now())+String ("<hr><b>printer:</b> ")+PrinterName+String ("<br><b>port:</b> ")+IntToStr(srv_port)+String ("<hr>")+String ("</Html>");
                String MsgHeader="Content-Length: "+IntToStr(SendMsg.Length())+"\r\nContent-Type: text/HTML\r\n\r\n";
        Socket->SendText(SendMsg) ;
        ((TMemoryStream*)Socket->Data)->WriteBuffer(Rb,ResLn);
        Socket->Close();
        delete Rb;
        return;
        }
        else
        {
         ((TMemoryStream*)Socket->Data)->WriteBuffer(Rb,ResLn);
         delete Rb;
        return;
        }

}
else
{
((TMemoryStream*)Socket->Data)->WriteBuffer(Rb,ResLn);
delete Rb;
}

}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::WebPrintServerClientDisconnect(
      TObject *Sender, TCustomWinSocket *Socket)
{


int ResLn=0;

do
  {
  ResLn=Socket->ReceiveLength();
  if(ResLn==0)break;
  char * Rb=new char[ResLn];
  Socket->ReceiveBuf(Rb,ResLn);
  ((TMemoryStream*)Socket->Data)->WriteBuffer(Rb,ResLn);
  delete Rb;
  }while(1);


 int JobSize=((TMemoryStream*)Socket->Data)->Size ;
 char * PrnBuf=new char[JobSize];
 ((TMemoryStream*)Socket->Data)->Position=0 ;
 ((TMemoryStream*)Socket->Data)->Read(PrnBuf,JobSize);

 if ( JobSize>3)
{
 if (PrnBuf[0]=='G' && PrnBuf[1]=='E' && PrnBuf[2]=='T' )
        {
        Log("GET from "+Socket->RemoteAddress,false);
          delete PrnBuf;
          delete (TMemoryStream*)Socket->Data;
          return;
        }
 }
 if(CB_Prn->Checked)((TMemoryStream*)Socket->Data)->SaveToFile("TCPPrint.prn");
 delete (TMemoryStream*)Socket->Data;

 String PrinterName="";
 int srv_port=0;
 TServerSocket * srv_SS=NULL;

 for(int c=0; c<ServiceList->Count; c++)
 {
  srv_SS=((Srv*)ServiceList->Items[c])->SS;

   for(int a=0; a<srv_SS->Socket->ActiveConnections;a++)
        {
        if(srv_SS->Socket->Connections[a]==Socket)
                {
                srv_port=srv_SS->Port;
                PrinterName=((Srv*)ServiceList->Items[c])->PN;
                break;
                }
        }
 }

 Log("Client: "+Socket->RemoteAddress+", Service: "+IntToStr(srv_port)+",  Printer: "+PrinterName+", JobSize: "+IntToStr(JobSize),false);
 int pp=0;
 bool print_rez=RawDataToPrinter(PrinterName.c_str(), PrnBuf,JobSize, Socket->RemoteAddress,pp);  //   PrinterName->Text.c_str()
 delete PrnBuf;
 Log("Client="+Socket->RemoteAddress+", PrintRezult="+IntToStr(print_rez),false);
}
//---------------------------------------------------------------------------
bool __fastcall TTCPPrintForm::RawDataToPrinter(LPSTR szPrinterName, LPBYTE lpData, DWORD dwCount, String IpAddr,int &PrintedPages)
{
HANDLE hPrinter;
DOC_INFO_1 DocInfo;
DWORD dwJob;
DWORD dwBytesWritten;

// Need a handle to the printer.
if( ! OpenPrinter( szPrinterName, &hPrinter, NULL ) )
{
Log(IpAddr+" - OpenPrinter=FALSE "+ szPrinterName,true);
return FALSE;
}

// Fill in the structure with info about this "document."
DocInfo.pDocName = "TCPPrint";
DocInfo.pOutputFile = NULL;
DocInfo.pDatatype = "RAW";

// Inform the spooler the document is beginning.
if( (dwJob = StartDocPrinter( hPrinter, 1, (LPSTR)&DocInfo )) == 0 )
{
ClosePrinter( hPrinter );
Log(IpAddr+" - StartDocPrinter=FALSE",true);
return FALSE;
}
// Start a page.
if( ! StartPagePrinter( hPrinter ) )
{

EndDocPrinter( hPrinter );
ClosePrinter( hPrinter );
Log(IpAddr+" - StartPagePrinter=FALSE",true);
return FALSE;
}

// Send the data to the printer.
if( !WritePrinter( hPrinter, lpData, dwCount, &dwBytesWritten ) )
{
EndPagePrinter( hPrinter );
EndDocPrinter( hPrinter );
ClosePrinter( hPrinter );
Log(IpAddr+" - WritePrinter=FALSE",true);
return FALSE;
}

// End the page.
if( ! EndPagePrinter( hPrinter ) )
{
EndDocPrinter( hPrinter );
ClosePrinter( hPrinter );
Log(IpAddr+" - EndPagePrinter=FALSE",true);
return FALSE;
}
// Inform the spooler that the document is ending.
if( ! EndDocPrinter( hPrinter ) )
{
ClosePrinter( hPrinter );
Log(IpAddr+" - EndDocPrinter=FALSE",true);
return FALSE;
}
// Tidy up the printer handle.
ClosePrinter( hPrinter );
// Check to see if correct number of bytes were written.
if( dwBytesWritten != dwCount )
{
Log(IpAddr+" - dwBytesWritten != dwCount",true);
return FALSE;
}
return TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::WebPrintServerClientError(TObject *Sender,
      TCustomWinSocket *Socket, TErrorEvent ErrorEvent, int &ErrorCode)
{
Socket->Close();
ErrorCode=0;
}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::FormCreate(TObject *Sender)
{
ServiceList=new TList;
Application->OnException=&MuEx;
if(FileExists("TCPPrint.ini")) ValueListEditor1->Strings->LoadFromFile("TCPPrint.ini");
if(ValueListEditor1->Cells[0][ValueListEditor1->Row].Trim().Length()==0 && ValueListEditor1->RowCount<3)
  {
   Btn_AddClick(Sender);
  }
}

//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::Log(String LogMessage, bool err)
{
LogMessage=DateTimeToStr(Now())+"-"+LogMessage+"\r\n";
  FILE * F;
  String LogFileName="TCPPrintJob.log";
  if(err)LogFileName="TCPPrintERR.log";
         if((F=fopen(LogFileName.c_str(),"a+"))==NULL) return;
         fwrite(LogMessage.c_str(),LogMessage.Length(),1,F);
         
         fclose(F);
}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::CB_StartClick(TObject *Sender)
{
if(CB_Start->Checked)
{
StartService();
}
else
{
 StopService();
}
}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::StopService()
{
if (ServiceList->Count>0)Log(" ------ Stop service ------",false);
 for(int i=0; i< ServiceList->Count ; i++)
 {

 ((Srv*)ServiceList->Items[i])->SS->Active=false;
 for(int c=0; c<((Srv*)ServiceList->Items[i])->SS->Socket->ActiveConnections; c++)
        {
        ((Srv*)ServiceList->Items[i])->SS->Socket->Connections[c]->Close();
        }
 delete ((Srv*)ServiceList->Items[i])->SS;
 delete (Srv*)ServiceList->Items[i];

 ServiceList->Delete(i);
 i--;
 }

}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::StartService()
{
Log(" ------ Start service ------ ",false);
static int srvcount=1;
for(int i=0; i<ValueListEditor1->RowCount; i++)
 {
 if (StrToIntDef(ValueListEditor1->Cells[1][i],0)>0)
  {
   srvcount++;
   Srv * PtrSrv=new Srv;
  
   TServerSocket * WebPrintService= new TServerSocket(this);
   WebPrintService->Name="TCPPrintService"+IntToStr(i+srvcount) ;
   WebPrintService->Port=StrToIntDef(ValueListEditor1->Cells[1][i],9100+i+srvcount);
   WebPrintService->ServerType=stNonBlocking;
   WebPrintService->Service="";
   WebPrintService->OnClientConnect=&WebPrintServerClientConnect;
   WebPrintService->OnClientRead=&WebPrintServerClientRead;
   WebPrintService->OnClientDisconnect=&WebPrintServerClientDisconnect;
   WebPrintService->OnClientError=&WebPrintServerClientError;
   PtrSrv->SS=WebPrintService;
   PtrSrv->PN=ValueListEditor1->Cells[0][i];
   ServiceList->Add(PtrSrv) ;
try{
WebPrintService->Active=true;
   }catch(...)
            {
            Log("Err start printer="+ValueListEditor1->Cells[0][i]+" on port="+ValueListEditor1->Cells[1][i],true);
            }
  }
 }
}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::MuEx(TObject *Sender, Exception *E)
{
String msgE=E->Message;

//if (SystemForm->ShowException->Checked)Application->ShowException(E);
Log(String("MuEx::")+msgE,true);
if(msgE.Pos("Access violation")>0)
{
Close();
}

}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{

ValueListEditor1->Strings->SaveToFile("TCPPrint.ini");
StopService();
delete ServiceList;
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::Btn_SaveClick(TObject *Sender)
{
 ValueListEditor1->Strings->SaveToFile("TCPPrint.ini");
}
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::Btn_AddClick(TObject *Sender)
{
//ValueListEditor1->Strings->Add("Printer name=port num.") ;
  TPrinter * print=new TPrinter;
  for(int i=0; i<print->Printers->Count; i++)
  {

        if (ValueListEditor1->Strings->Text.Pos(print->Printers->Strings[i])==0)
                {
                ValueListEditor1->Strings->Add(print->Printers->Strings[i]+"=");
                }

   }

  delete print;
 /* PRINTDLG pd;
    ZeroMemory(&pd, sizeof(PRINTDLG));

    //  PRINTDLG
    pd.lStructSize = sizeof(PRINTDLG);
    pd.hwndOwner = Handle;
    pd.nCopies = 1;
    pd.nFromPage = 0xFFFF;
    pd.nToPage = 0xFFFF;
    pd.nMinPage = 1;
    pd.nMaxPage = 0xFFFF;
    pd.Flags = PD_ENABLEPRINTHOOK;
   pd.lpfnPrintHook = PrintHookProc;

    if (PrintDlg(&pd))
    {
        //   ...

        if (pd.hDevMode) GlobalFree(pd.hDevMode);
        if (pd.hDevNames) GlobalFree(pd.hDevNames);
    }

 */
/* char *def_string = " ";
    char buffer[MAX_PATH]; 
    GetProfileString("windows", "printer", def_string, 
                     buffer, MAX_PATH); 

    AnsiString Abuffer(buffer); 
    AnsiString Device, Driver, Port; 

    //  ,   
    int first_comma = Abuffer.Pos(","); 
    Device = Abuffer.SubString(1, first_comma - 1);
    Abuffer = Abuffer.SubString(first_comma + 1,
              Abuffer.Length() - first_comma); 
    int second_comma = Abuffer.Pos(","); 
    Driver = Abuffer.SubString(1, second_comma - 1);
    Port = Abuffer.SubString(second_comma + 1,
                             Abuffer.Length() - second_comma);
  Log("Device="+Device,false) ;
   Log("Abuffer="+Abuffer,false) ;
    Log("Driver="+Driver,false) ;
     Log("Port="+Port,false) ;
     
 */
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::CB_HideClick(TObject *Sender)
{
if(CB_Hide->Checked)
{
Hide();
}
}
//---------------------------------------------------------------------------



void __fastcall TTCPPrintForm::Btn_AboutClick(TObject *Sender)
{
AboutBox->Show();
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::Btn_HelpClick(TObject *Sender)
{
String p=ExtractFileDir(Application->ExeName);
p=p+ "\\TCPPrint_readme.htm";

ShellExecute(Application->Handle,"open",p.c_str(), "","",SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::Btn_ErrClick(TObject *Sender)
{
String p=ExtractFileDir(Application->ExeName);
p=p+ "\\TCPPrintERR.log";

ShellExecute(Application->Handle,"open",p.c_str(), "","",SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::Btn_LogClick(TObject *Sender)
{
String p=ExtractFileDir(Application->ExeName);
p=p+ "\\TCPPrintJob.log";

ShellExecute(Application->Handle,"open",p.c_str(), "","",SW_SHOW);        
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::Btn_NetstatClick(TObject *Sender)
{
String p=ExtractFileDir(Application->ExeName);
p=p+ "\\TCPPrint_netstat.bat";

ShellExecute(Application->Handle,"open",p.c_str(), "","",SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::Btn_DeleteClick(TObject *Sender)
{


String Q="Delete record ?\r\nPrinter name: "+ValueListEditor1->Cells[0][ValueListEditor1->Row]+"\r\nPort: "+ValueListEditor1->Cells[1][ValueListEditor1->Row];
if (IDYES ==Application->MessageBox(Q.c_str(), "TCPPrint - Delete record", MB_YESNO	))
   {
   ValueListEditor1->DeleteRow(ValueListEditor1->Row) ;
   ValueListEditor1->Strings->SaveToFile("TCPPrint.ini");
   }
}
//---------------------------------------------------------------------------
String __fastcall TTCPPrintForm::ListJobsForPrinter( String szPrinterName,bool htm )
   {
   String br="";
   String h2s="<h2>";
   String h2e="</h2>";
    if (szPrinterName.Trim().Length()==0)
    {
        if (!htm)
                {
                h2s="";
                h2e="";
                }
    return h2s+"Please, choose printer name..."+h2e;
    }
   HANDLE         hPrinter;
   DWORD          dwNeeded, dwReturned, i;
   JOB_INFO_1     *pJobInfo;

   //    ,   
   if( ! OpenPrinter( szPrinterName.c_str(), &hPrinter, NULL ) )
     return "Err Open Printer: "+szPrinterName;

   //   EnumJobs()  ,   
   // 
   if( ! EnumJobs( hPrinter, 0, 0xFFFFFFFF, 1, NULL, 0, &dwNeeded,
                   &dwReturned ) )
   {
     //        
     if( GetLastError() != ERROR_INSUFFICIENT_BUFFER )
     {
       ClosePrinter( hPrinter );
       return "Memory Err (EnumJobs)";
     }
   }
   //       JOB_INFO_1
   //    - dwNeeded   
   //  ,   
   if( (pJobInfo = (JOB_INFO_1 *)malloc( dwNeeded )) == NULL )
   {
     ClosePrinter( hPrinter );
     return "Memory Err (JobInfo)";
   }
   //  EnumJobs() ,    
   if( ! EnumJobs( hPrinter, 0, 0xFFFFFFFF, 1, (LPBYTE)pJobInfo,
                   dwNeeded, &dwNeeded, &dwReturned ) )
   {
     ClosePrinter( hPrinter );
     free( pJobInfo );
     return "Err EnumJobs";
   }
   //      ,   
   ClosePrinter( hPrinter );

   // dwReturned  ,   
   //     
   br="<br>\r\n";
   if (!htm)br="";
   String RetStr=szPrinterName+"\r\n"+br+"Total print jobs=";
   RetStr=RetStr+String(dwReturned )+"\r\n "+br;

   //          
   for(i=0;i<dwReturned;i++)
   {
     // pJobInfo[i]   JOB_INFO_1   
     RetStr=RetStr+ String(pJobInfo[i].pMachineName)+" - " + String(pJobInfo[i].pUserName)+" - " + String(pJobInfo[i].pDocument)+" - " + String(pJobInfo[i].pStatus)+"\r\n "+br;

   }

   // 
   free( pJobInfo );
   return RetStr;
 }
//---------------------------------------------------------------------------
void __fastcall TTCPPrintForm::Btn_JobClick(TObject *Sender)
{
//  ShowMessage(ListJobsForPrinter(ValueListEditor1->Cells[0][ValueListEditor1->Row],false));
   Show_queue();
}
//-----------------------------------------------------------------------------
void __fastcall TTCPPrintForm::Show_queue(void)
{
char CNS[100];
unsigned long CN=sizeof(CNS);
GetComputerName(CNS,&CN)  ;
String ComputerNameStr=String(CNS);
String RunStr="rundll32 printui.dll,PrintUIEntry /o /n\"\\\\"+ComputerNameStr+"\\"+ValueListEditor1->Cells[0][ValueListEditor1->Row]+"\"";

//ShowMessage(RunStr);
WinExec( RunStr.c_str(),SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TTCPPrintForm::ValueListEditor1StringsChange(
      TObject *Sender)
{
 // ShowMessage(ValueListEditor1->RowCount);
  if (ValueListEditor1->RowCount>1 && ValueListEditor1->Cells[0][ValueListEditor1->Row].Trim().Length()>0)
  {
   Btn_Delete->Enabled=true;
   Btn_Job->Enabled=true;
  }

  if(ValueListEditor1->Cells[0][ValueListEditor1->Row].Trim().Length()==0 && ValueListEditor1->RowCount<3)
  {
  Btn_Delete->Enabled=false;
  Btn_Job->Enabled=false;
  }
}
//---------------------------------------------------lf &------------------------


void __fastcall TTCPPrintForm::ValueListEditor1DblClick(TObject *Sender)
{
Show_queue();        
}
//---------------------------------------------------------------------------

